﻿
// type of camera
var typeId = "Microsoft.VisualStudio.3D.OrthographicCamera";
var nodeTypeId = "Microsoft.VisualStudio.3D.SceneNode";

// camera to create
var newCamera = services.elementTypeSet.cloneByTypeId(typeId);

// camera node
var newCameraNode = services.elementTypeSet.cloneByTypeId(nodeTypeId);

// set the parent
newCamera.parent = newCameraNode;

// save the current camera
var currentCamera = document.getCurrentCamera();

var GridPlaneOrientationTopRight = 2;
document.setGridOrientation(GridPlaneOrientationTopRight);

document.setCurrentCamera(newCamera);
document.elements.append(newCameraNode);
document.elements.append(newCamera);

// delete the old camera
document.deleteSceneElement(currentCamera.parent);

//
// view front
//
var coord = document.getCoordinateSystemMatrix();
var relPos = math.getForwardVector(coord);

document.frameSelection(relPos[0], relPos[1], relPos[2], true);

// SIG // Begin signature block
// SIG // MIIkBwYJKoZIhvcNAQcCoIIj+DCCI/QCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // v/k1PnLixglmkFX1UacO8WCJgLY9UCoL8DfZ0jnCBN6g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcwwghXIAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggbwwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIIAowe0OrqCwIbG2odjpNyYQ3PfBJtJsnqiRKK02
// SIG // 5LhIMFAGCisGAQQBgjcCAQwxQjBAoCaAJABNAHIAZQBP
// SIG // AHIAdABoAG8AZwByAGEAcABoAGkAYwAuAGoAc6EWgBRo
// SIG // dHRwOi8vbWljcm9zb2Z0LmNvbTANBgkqhkiG9w0BAQEF
// SIG // AASCAQAnkKUgRcYhdmJuCvASVHODunDTHdDVKqzm/eIt
// SIG // vHGf7iioeZ4gqzbGGAkDqYfvH8SOWg+5yQaHSWlUOUBZ
// SIG // ki+c2Az7I20bYxGr0MF7tFpW+oaM6dYzkz2Vy1Wujbgu
// SIG // xJgiDxYYKJ50DS3JD7UbCKeh73sv6rS4iCP9JfwvtFV2
// SIG // ogjZZSACUxs1BJbRA2NRUekOFmkuDQUkQlr0Io8jKyVk
// SIG // UMX55CnBa6GL65P7Nmu+gGO2EWe95fBP94MuHYTc+GxG
// SIG // hwDrTHDPghVGnToNGd0RYtQVHXXNJmIG5QUX6ZECKb/E
// SIG // cayxntzxlpPwHcgw6R+nrb8Xzk8Z1Bl0Wj451vXeoYIT
// SIG // SDCCE0QGCisGAQQBgjcDAwExghM0MIITMAYJKoZIhvcN
// SIG // AQcCoIITITCCEx0CAQMxDzANBglghkgBZQMEAgEFADCC
// SIG // ATsGCyqGSIb3DQEJEAEEoIIBKgSCASYwggEiAgEBBgor
// SIG // BgEEAYRZCgMBMDEwDQYJYIZIAWUDBAIBBQAEIPPFb2Pa
// SIG // iJAsBCDpPpxY1I/YvlydYK4IEE1BSuJ4MLA4AgZYr7I5
// SIG // tKgYETIwMTcwMzA0MjMyNDA2LjdaMAcCAQGAAgH0oIG5
// SIG // pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQL
// SIG // EwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046
// SIG // QjhFQy0zMEE0LTcxNDQxJTAjBgNVBAMTHE1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFNlcnZpY2Wggg7NMIIGcTCCBFmg
// SIG // AwIBAgIKYQmBKgAAAAAAAjANBgkqhkiG9w0BAQsFADCB
// SIG // iDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEyMDAGA1UEAxMpTWlj
// SIG // cm9zb2Z0IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
// SIG // IDIwMTAwHhcNMTAwNzAxMjEzNjU1WhcNMjUwNzAxMjE0
// SIG // NjU1WjB8MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQD
// SIG // Ex1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDCC
// SIG // ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKkd
// SIG // Dbx3EYo6IOz8E5f1+n9plGt0VBDVpQoAgoX77XxoSyxf
// SIG // xcPlYcJ2tz5mK1vwFVMnBDEfQRsalR3OCROOfGEwWbEw
// SIG // RA/xYIiEVEMM1024OAizQt2TrNZzMFcmgqNFDdDq9UeB
// SIG // zb8kYDJYYEbyWEeGMoQedGFnkV+BVLHPk0ySwcSmXdFh
// SIG // E24oxhr5hoC732H8RsEnHSRnEnIaIYqvS2SJUGKxXf13
// SIG // Hz3wV3WsvYpCTUBR0Q+cBj5nf/VmwAOWRH7v0Ev9buWa
// SIG // yrGo8noqCjHw2k4GkbaICDXoeByw6ZnNPOcvRLqn9Nxk
// SIG // vaQBwSAJk3jN/LzAyURdXhacAQVPIk0CAwEAAaOCAeYw
// SIG // ggHiMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1UdDgQWBBTV
// SIG // YzpcijGQ80N7fEYbxTNoWoVtVTAZBgkrBgEEAYI3FAIE
// SIG // DB4KAFMAdQBiAEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0T
// SIG // AQH/BAUwAwEB/zAfBgNVHSMEGDAWgBTV9lbLj+iiXGJo
// SIG // 0T2UkFvXzpoYxDBWBgNVHR8ETzBNMEugSaBHhkVodHRw
// SIG // Oi8vY3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9k
// SIG // dWN0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcmww
// SIG // WgYIKwYBBQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRw
// SIG // Oi8vd3d3Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01p
// SIG // Y1Jvb0NlckF1dF8yMDEwLTA2LTIzLmNydDCBoAYDVR0g
// SIG // AQH/BIGVMIGSMIGPBgkrBgEEAYI3LgMwgYEwPQYIKwYB
// SIG // BQUHAgEWMWh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9Q
// SIG // S0kvZG9jcy9DUFMvZGVmYXVsdC5odG0wQAYIKwYBBQUH
// SIG // AgIwNB4yIB0ATABlAGcAYQBsAF8AUABvAGwAaQBjAHkA
// SIG // XwBTAHQAYQB0AGUAbQBlAG4AdAAuIB0wDQYJKoZIhvcN
// SIG // AQELBQADggIBAAfmiFEN4sbgmD+BcQM9naOhIW+z66bM
// SIG // 9TG+zwXiqf76V20ZMLPCxWbJat/15/B4vceoniXj+bzt
// SIG // a1RXCCtRgkQS+7lTjMz0YBKKdsxAQEGb3FwX/1z5Xhc1
// SIG // mCRWS3TvQhDIr79/xn/yN31aPxzymXlKkVIArzgPF/Uv
// SIG // eYFl2am1a+THzvbKegBvSzBEJCI8z+0DpZaPWSm8tv0E
// SIG // 4XCfMkon/VWvL/625Y4zu2JfmttXQOnxzplmkIz/amJ/
// SIG // 3cVKC5Em4jnsGUpxY517IW3DnKOiPPp/fZZqkHimbdLh
// SIG // nPkd/DjYlPTGpQqWhqS9nhquBEKDuLWAmyI4ILUl5WTs
// SIG // 9/S/fmNZJQ96LjlXdqJxqgaKD4kWumGnEcua2A5HmoDF
// SIG // 0M2n0O99g/DhO3EJ3110mCIIYdqwUB5vvfHhAN/nMQek
// SIG // kzr3ZUd46PioSKv33nJ+YWtvd6mBy6cJrDm77MbL2IK0
// SIG // cs0d9LiFAR6A+xuJKlQ5slvayA1VmXqHczsI5pgt6o3g
// SIG // My4SKfXAL1QnIffIrE7aKLixqduWsqdCosnPGUFN4Ib5
// SIG // KpqjEWYw07t0MkvfY3v1mYovG8chr1m1rtxEPJdQcdeh
// SIG // 0sVV42neV8HR3jDA/czmTfsNv11P6Z0eGTgvvM9YBS7v
// SIG // DaBQNdrvCScc1bN+NR4Iuto229Nfj950iEkSMIIE2jCC
// SIG // A8KgAwIBAgITMwAAAJ9n8rWoIwZbewAAAAAAnzANBgkq
// SIG // hkiG9w0BAQsFADB8MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYw
// SIG // JAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Eg
// SIG // MjAxMDAeFw0xNjA5MDcxNzU2NDdaFw0xODA5MDcxNzU2
// SIG // NDdaMIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2Fz
// SIG // aGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
// SIG // ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQL
// SIG // EwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBFU046
// SIG // QjhFQy0zMEE0LTcxNDQxJTAjBgNVBAMTHE1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFNlcnZpY2UwggEiMA0GCSqGSIb3
// SIG // DQEBAQUAA4IBDwAwggEKAoIBAQC5CPEjnN3EAi8ChaGj
// SIG // J5dk+QOcElQ/U4JauD7rfW4YxXLBJ9VwKQzwlkvWj4TH
// SIG // FjlinvuxDSOEouMw99J1UAvT2dDQ7vqSvV1fNzn4xnIR
// SIG // ZCszgUXXToabEJMRYDBd0Xy0zVwBKn35zWkXl8LVVJIh
// SIG // hCb1uipgAYscz9GnlFZiejB5yZ5qPkymXaFZe3IOk2Oi
// SIG // wqM3vxeq4Tl5ovz91/yt4x7ZgGsS/Trud44w4DuUY8be
// SIG // mRGpnRLBhdklmesB+g5oPRuomT8YMPpozg8EXi+o8Iex
// SIG // 9l4bL86BTK0hETMyCH9niRgDPQtBkdAWR8kbYte0Ki+U
// SIG // 2grlj4zMUyl1+A5ZAgMBAAGjggEbMIIBFzAdBgNVHQ4E
// SIG // FgQU/YsbIsN9I0d2ph7f4GbUUum2+aAwHwYDVR0jBBgw
// SIG // FoAU1WM6XIoxkPNDe3xGG8UzaFqFbVUwVgYDVR0fBE8w
// SIG // TTBLoEmgR4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29t
// SIG // L3BraS9jcmwvcHJvZHVjdHMvTWljVGltU3RhUENBXzIw
// SIG // MTAtMDctMDEuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggr
// SIG // BgEFBQcwAoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29t
// SIG // L3BraS9jZXJ0cy9NaWNUaW1TdGFQQ0FfMjAxMC0wNy0w
// SIG // MS5jcnQwDAYDVR0TAQH/BAIwADATBgNVHSUEDDAKBggr
// SIG // BgEFBQcDCDANBgkqhkiG9w0BAQsFAAOCAQEAZRDBbGvP
// SIG // FR6vD0g2698tC7wAAOaRZhpQlmW5MQ9ljKnxdMvH55b4
// SIG // G/O+M/LM/EGcwcgpmNYx8h03PfGXpM+y9mOUgDVCGvI8
// SIG // lN+nOuApOX2Oj3vYVANURv9cz/nqtPNHIVDwhds3s4X8
// SIG // Ls/Tm9KGzuuAcFtBmYGGM9YY7KvgwZEggUVefa8hac4C
// SIG // kcIVhfKrl7Rw6YpoicfnbNlWUsBFZP0EWO6S7lL3nTfD
// SIG // +Qzbi2mkcN6CXLNlsYdo1kuU/GNyXr1KNyt1U7Rz4tiA
// SIG // ViEpBBu0zpzRFHFFwzBkjnmdu5LjxcypA1W7c78BFXqZ
// SIG // Bq7GdVvtcbg2D0NW9wTBvAu/R6GCA3YwggJeAgEBMIHj
// SIG // oYG5pIG2MIGzMQswCQYDVQQGEwJVUzETMBEGA1UECBMK
// SIG // V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwG
// SIG // A1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMQ0wCwYD
// SIG // VQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVyIERTRSBF
// SIG // U046QjhFQy0zMEE0LTcxNDQxJTAjBgNVBAMTHE1pY3Jv
// SIG // c29mdCBUaW1lLVN0YW1wIFNlcnZpY2WiJQoBATAJBgUr
// SIG // DgMCGgUAAxUAbNMnCPL52ajL+RnekktKrdsZo8GggcIw
// SIG // gb+kgbwwgbkxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xDTALBgNV
// SIG // BAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIgTlRTIEVT
// SIG // Tjo1N0Y2LUMxRTAtNTU0QzErMCkGA1UEAxMiTWljcm9z
// SIG // b2Z0IFRpbWUgU291cmNlIE1hc3RlciBDbG9jazANBgkq
// SIG // hkiG9w0BAQUFAAIFANxlcMAwIhgPMjAxNzAzMDQxNjU4
// SIG // NDBaGA8yMDE3MDMwNTE2NTg0MFowdDA6BgorBgEEAYRZ
// SIG // CgQBMSwwKjAKAgUA3GVwwAIBADAHAgEAAgImLDAHAgEA
// SIG // AgIZAjAKAgUA3GbCQAIBADA2BgorBgEEAYRZCgQCMSgw
// SIG // JjAMBgorBgEEAYRZCgMBoAowCAIBAAIDFuNgoQowCAIB
// SIG // AAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IBAQAcEM6G+E/p
// SIG // vOUBmyeSKwi5F1bVE5EwIMas5BUCJEGSMQZwpeMfAmhR
// SIG // vMqCKIQluxxQDB76vT0fmv58Y7CX98IKOm2obiHptzYB
// SIG // mIrdhZL/uK/f3Yv9JIggZ/+VRWEgxQNE7y0GQRaRL/Da
// SIG // lkYkm5OA8riS/8vpz1LZ2h10Wg4Qn+adK67LwB/6DF2T
// SIG // 3jC63OoMcRAIXmlTc/uathsyK4SLqho65nR0K+moUETF
// SIG // N+QbSn9NQoC7Y4ZPakzp7G75kPvCPg9QIpJ90Bfw+AyO
// SIG // +7YcTSQxpe+pRg9Wyy76IR5S2BQrmsfu2BpzSH2FR7rg
// SIG // qIs5N7gHTKSiJevToiVH4lCnMYIC9TCCAvECAQEwgZMw
// SIG // fDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0
// SIG // b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1p
// SIG // Y3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWlj
// SIG // cm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIwMTACEzMAAACf
// SIG // Z/K1qCMGW3sAAAAAAJ8wDQYJYIZIAWUDBAIBBQCgggEy
// SIG // MBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRABBDAvBgkq
// SIG // hkiG9w0BCQQxIgQgBDy+wdPRhp6G4UxjNHfuBGnCQ3jL
// SIG // aHI5PDtS4W03sZgwgeIGCyqGSIb3DQEJEAIMMYHSMIHP
// SIG // MIHMMIGxBBRs0ycI8vnZqMv5Gd6SS0qt2xmjwTCBmDCB
// SIG // gKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNo
// SIG // aW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQK
// SIG // ExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMT
// SIG // HU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMz
// SIG // AAAAn2fytagjBlt7AAAAAACfMBYEFHaE/6wvUgY8ahiL
// SIG // t1J12IUtHCg2MA0GCSqGSIb3DQEBCwUABIIBABQinoxp
// SIG // G8LmDFKbwNa8/6B4A/3HCj5UrnnODn7EwXPWcTRlShqO
// SIG // vAf1MTWva2JTzNBjlJwKybuU85yWGSt86dqk3KIf6nRl
// SIG // d0ww4RTh2JTt0uxz7+4TKoRnDlIXR+tcEva/HPYoj5EQ
// SIG // Xs+nmP9zk24i2WUnn14sByxvlYGGaPgb7lWpryYgKJaV
// SIG // NLMzSVToojkCfwI/p/W2gd5fSJAQpT+A4PJL3r1mayN1
// SIG // 6Bton29sa4+nyKuejXAczXhyqN2aeCkaAN+7ZpUajjX3
// SIG // /3rIVpJLO1cUtv+dG72ocgj5wUYR0HFVtsZC48ywm4ww
// SIG // weY8EqA622jAl8cIjsl+CCGD7ic=
// SIG // End signature block
